#!/bin/sh

. ./_blfsset.sh

APPNAME=porg
VER=0.8
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	bash-completion gtkmm
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
	$([ ${OPTION_gtkmm} -ne 1 ] && echo --disable-grop) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
make install \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo Installing Me...
make logme \
	1> $LOG/$TARGET.4_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

