#!/bin/sh

. ./_blfsset.sh

APPNAME=openssh
VER=7.1p1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh openssl
. $WRK/_checkOptions.sh  \
	Linux-PAM krb5 libedit \
        opensc libsectok openjdk net-tools sysstat
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if test "${OPTION_LinuxPAM}" == "1";  then
  export WITHPAM="--with-pam "
else
  export WITHPAM=""
fi

if test "${OPTION_krb5}" == "1";  then
  export WITHKERBEROS5="--with-kerberos5=/usr "
else
  export WITHKERBEROS5=""
fi

#if test "${OPTION_tcp_wrappers}" == "1";  then
#  export WITHTCPWRAPPERS="--with-tcp-wrappers=/usr "
#else
#  export WITHTCPWRAPPERS=""
#fi

if test "${OPTION_libedit}" == "1"; then
  export WITHLIBEDIT="--with-libedit=/usr "
else
  export WITHLIBEDIT=""
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

install -v -m700 -d /var/lib/sshd
chown -v root:sys /var/lib/sshd

groupadd -g 50 sshd &&
useradd -c 'sshd PrivSep' -d /var/lib/sshd -g sshd \
    -s /bin/false -u 50 sshd

Configuring
./configure --prefix=/usr                     \
            --sysconfdir=/etc/ssh             \
            --with-md5-passwords              \
            --with-privsep-path=/var/lib/sshd \
    $WITHPAM $WITHKERBEROS5 \
    $WITHTCPWRAPPERS $WITHLIBEDIT \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

#echo \ \ Testing...
#make tests \
#	1> $LOG/$TARGET.3_test.log 2>&1 || echo Error occured in testing

#echo \ \ Result of Testing
#grep FATAL $LOG/$TARGET.3_test.log

Installing
porg -lp $TARGET "make install"  \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m755 contrib/ssh-copy-id /usr/bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644 contrib/ssh-copy-id.1 /usr/share/man/man1" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m755 -d /usr/share/doc/openssh-$VER"  \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644 INSTALL LICENCE OVERVIEW README* \
    /usr/share/doc/openssh-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

