#!/bin/sh

. ./_blfsset.sh

APPNAME=obexd
VER=0.48
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	bluez libical
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's/#include <string.h>/&\n#include <stdio.h>/' plugins/mas.c

Configuring
./configure --prefix=/usr --libexecdir=/usr/lib/obex \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

