#!/bin/sh

. ./_blfsset.sh

APPNAME=libjpeg-turbo
VER=1.3.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh yasm
. $WRK/_checkOptions.sh ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i -e "/^docdir/     s:$:/libjpeg-turbo-$VER:" \
       -e "/^exampledir/ s:$:/libjpeg-turbo-$VER:" Makefile.in

Configuring
./configure --prefix=/usr \
            --mandir=/usr/share/man \
            --with-jpeg8 \
            --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "\
make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

