#!/bin/sh

. ./_blfsset.sh

APPNAME=libidn
VER=1.32
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	pth emacs gtk-doc openjdk mono valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_openjdk} -eq 1 ]; then
#  export ENABLEJAVA="--enable-java "
#else
#  export ENABLEJAVA=""
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr --disable-static \
	$([ ${OPTION_openjdk} -eq 1 ] && echo --enable-java) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

find doc -name "Makefile*" -delete \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

rm -rf -v doc/{gdoc,idn.1,stamp-vti,man,texi} \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
mkdir -pv /usr/share/doc/libidn-$VER \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
cp -r -v doc/* /usr/share/doc/libidn-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

