#!/bin/sh

. ./_blfsset.sh

APPNAME=js
VER=17.0.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/mozjs$VER.tar.gz
TARGETDIR=moz$APPNAME$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	libffi nspr python-2 zip
. $WRK/_checkOptions.sh  \
	doxygen makedepend
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

cd js/src

Configuring
./configure --prefix=/usr       \
            --enable-readline   \
            --enable-threadsafe \
            --with-system-ffi   \
            --with-system-nspr  \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

find /usr/include/js-17.0/            \
     /usr/lib/libmozjs-17.0.a         \
     /usr/lib/pkgconfig/mozjs-17.0.pc \
     -type f -exec chmod -v 644 {} \; \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../../..
RemoveSrcDir
PorgingDone

