#!/bin/sh

. ./_blfsset.sh

APPNAME=ghostscript
VER=9.05
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

echo Check Required...
./_checkRequired.sh expat freetype jasper libjpeg libpng tiff lcms || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

rm -rf expat freetype jpeg lcms2 libpng tiff
rm -rf jasper lcms zlib

echo \ \ Configuring...
./configure --prefix=/usr --enable-dynamic --with-system-libtiff LIBS=-lz \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Making so...
make so \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo \ \ Installing so...
paco -p+ $TARGET "make soinstall" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 base/*.h /usr/include/ghostscript" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -v -s ghostscript /usr/include/ps" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -rf doc /usr/share/ghostscript/$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -sv ../ghostscript/$VER/doc /usr/share/doc/ghostscript-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
tar -xvf $DLD/ghostscript-fonts-std-8.11.tar.gz \
  -C /usr/share/ghostscript --no-same-owner"

paco -p+ $TARGET "\
tar -xvf $DLD/gnu-gs-fonts-other-6.0.tar.gz \
  -C /usr/share/ghostscript --no-same-owner"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

