#!/bin/sh

. ./_blfsset.sh

APPNAME=flac
VER=1.3.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	libogg nasm docbook-utils doxygen valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching...
#patch -Np1 -i $WRK/patch/flac-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#sed -i 's/#include <stdio.h>/&\n#include <string.h>/' \
#    examples/cpp/encode/file/main.cpp

Configuring
./configure --prefix=/usr \
	--disable-thorough-tests \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

