#!/bin/sh

. ./_blfsset.sh

APPNAME=db
VER=6.1.26
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	tcl openjdk jdk sharutils
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
cd build_unix
../dist/configure --prefix=/usr      \
                  --enable-compat185 \
                  --enable-dbm       \
                  --disable-static   \
                  --enable-cxx       \
$([ "${OPTION_openjdk}" = "1" ] && echo --enable-java ) \
$([ "${OPTION_jdk}" = "1" ] && echo --enable-java ) \
$([ "${OPTION_tcl}" = "1" ] && echo --enable-tcl --with-tcl=/usr/lib ) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make docdir=/usr/share/doc/db-$VER install"  \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chown -v -R root:root \
      /usr/bin/db_* \
      /usr/include/db{,_185,_cxx}.h \
      /usr/lib/libdb*.{so,la} \
      /usr/share/doc/db-$VER \
	1> $LOG/$TARGET.4_chown.log 2>&1 || echo Error occurred!

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

