#!/bin/sh

case `uname -m` in
  i?86)
    export CPUBIT=32
    ;;
  x86_64)
    export CPUBIT=64
    ;;
  *)
    export CPUBIT=
    ;;
esac

LFS=/mnt/lfs
SRC=$LFS/sources/BLFS
DLD=$LFS/download/BLFS
WRK=$LFS/work/LFScripts/BLFS
LOG=$WRK/log$CPUBIT
TME=$WRK/time$CPUBIT

XORGSRC=$SRC/Xorg
XORGDLD=$DLD/Xorg
XORGWRK=$WRK/Xorg

QTDIR=/opt/qt

BOOTSCRIPTDATE=20150823

mkdir -pv $LOG $TME

function TimeStart() {
  START=`date +'%Y/%m/%d %H:%M:%S.%N'`
  return 0
}

function TimeEnd() {
  END=`date +'%Y/%m/%d %H:%M:%S.%N'`
  echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt
}

function Patching() {
  echo Patching...
}

function Configuring() {
  echo Configuring...
}

function Making() {
  echo Making...
}

function Installing() {
  echo Installing...
}

function PorgingDone() {
  local pkg=$TARGET
  if test "$1" != ""; then
    pkg=$1
  fi
  echo --------------------
  echo -n Porging:\   && porg $pkg || echo none
  echo Done.
}

function RemoveSrcDir() {
  echo Removing source directory...
  rm -fr $TARGETDIR
}

function Extract() {
  local FILE=$TARGETBALL

  if test "$1" != ""; then
    FILE=$1
  fi

  echo Extracting sources...
  if test ! -f $FILE; then
    echo \ \ Tarball not found: $FILE && exit 1
  else
    tar xf $FILE
  fi
}

function ExtractZip() {
  local FILE=$TARGETBALL

  if test "$1" != ""; then
    FILE=$1
  fi

  echo Extracting sources...
  if ! test -f $FILE; then
    echo \ \ Zip not found: $FILE && exit 1
  else
    unzip $FILE 1> /dev/null || exit 1
  fi
}

