#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=libxcb
VER=1.11
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libXau libXdmcp xcb-proto
. $WRK/_checkOptions.sh  \
	doxygen check libxslt
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed "s/pthread-stubs//" -i configure

#echo Autoreconfing...
#autoreconf -fiv \
#	1> $LOG/$TARGET.0_autoconf.log 2>&1 || exit 1

Configuring
./configure $XORG_CONFIG \
            --enable-xinput \
            --docdir='${datadir}'/doc/libxcb-$VER \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

