#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

section=font
version=$XORGVERSION

TARGET=${section}-${version}
TARGETDIR=${section}

mkdir -pv $XORGDLD/$TARGETDIR
mkdir -pv $XORGSRC/$TARGETDIR

cd $XORGDLD/$TARGETDIR

grep -v '^#' $XORGWRK/${section}-${version}.md5 | awk '{print $2}' | wget -N -i- -c \
    -B http://xorg.freedesktop.org/releases/individual/${section}/ \
        1> $LOG/Xorg-$section.log 2>&1
md5sum -c $XORGWRK/${section}-${version}.md5 \
        1>> $LOG/Xorg-$section.log 2>&1

cd $XORGSRC/$TARGETDIR

# build packages
for package in $(grep -v '^#' $XORGWRK/${section}-${version}.md5 | awk '{print $2}')
do
  packagedir=$(echo $package | sed 's/.tar.bz2//')
echo $packagedir
echo \ \ Removing old directory...
  rm -fr $packagedir
echo \ \ Extracting...
  tar -xf $XORGDLD/$TARGETDIR/$package || (echo Tarball not found && exit 1)
  cd $packagedir
START=`date +'%Y/%m/%d %H:%M:%S.%N'`
echo \ \ Configuring...
  ./configure $XORG_CONFIG \
	1> $LOG/Xorg-${section}-${packagedir}.1_conf.log 2>&1 || exit 1
echo \ \ Making...
  make \
	1> $LOG/Xorg-${section}-${packagedir}.2_make.log 2>&1 || exit 1
echo \ \ Installing...
  paco -p Xorg-${section}-${packagedir} 'make install' \
	1> $LOG/Xorg-${section}-${packagedir}.3_install.log 2>&1 || exit 1
  cd ..
END=`date +'%Y/%m/%d %H:%M:%S.%N'`
echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/Xorg-${section}-${packagedir}.txt

echo -n \ \ Pacoing:\   && paco Xorg-${section}-${packagedir} || echo none
echo \ \ Removing directory...
  rm -fr $packagedir
done

install -v -d -m755 /usr/share/fonts

ln -svn $XORG_PREFIX/share/fonts/X11/OTF /usr/share/fonts/X11-OTF 
ln -svn $XORG_PREFIX/share/fonts/X11/TTF /usr/share/fonts/X11-TTF

