#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=tar
VER=1.27.1
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/tar-$VER-manpage-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1

echo \ \ Configuring...
FORCE_UNSAFE_CONFIGURE=1  \
./configure --prefix=/usr \
            --bindir=/bin \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

echo \ \ Installing doc...
paco -p+ $TARGET "make -C doc install-html docdir=/usr/share/doc/tar-$VER" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1
paco -p+ $TARGET "\
perl tarman > /usr/share/man/man1/tar.1" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1

TimeEnd chap6

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

