#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=libcap
VER=2.24
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "\
make RAISE_SETFCAP=no prefix=/usr install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
chmod -v 755 /usr/lib/libcap.so

paco -p+ $TARGET "\
mv -v /usr/lib/libcap.so.* /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libcap.so) /usr/lib/libcap.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

