#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=gmp
VER=5.1.3
TARGET=gmp-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr --enable-cxx \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

#echo \ \ Checking...
#make check \
#	1> $LOG/$CHAP.$TARGET.3_check.log 2>&1 || exit 1

#awk '/tests passed/{total+=$2} ; END{print total}' \
#	$LOG/$CHAP.$TARGET.3_check.log

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

mkdir -v /usr/share/doc/gmp-$VER
paco p+ $TARGET "\
cp    -v doc/{isa_abi_headache,configuration} doc/*.html \
         /usr/share/doc/gmp-$VER" \
	1> $LOG/$CHAP.$TARGET.4_copy.log 2>&1 || echo Error occured in copying.

TimeEnd chap6

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

