#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=0.18.1.1
TARGET=gettext-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR
cd gettext-tools

echo "gl_cv_func_wcwidth_works=yes" > config.cache

echo \ \ Configuring...
CC="${CC} ${BUILD64}" CXX="${CXX} ${BUILD64}" \
    ./configure --prefix=/tools --disable-shared \
    --build=${CLFS_HOST} --host=${CLFS_TARGET} \
    --cache-file=config.cache \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make -C gnulib-lib \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make -C src msgfmt \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
cp -v src/msgfmt /tools/bin \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/clfstime.txt

echo \ \ Removing directory...
cd ../.. && rm -fr $TARGETDIR

echo \ \ Done.

