#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=3.4.0
TARGET=iproute2-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

sed -i '/^TARGETS/s@arpd@@g' misc/Makefile
sed -i '/ARPD/d' Makefile
rm -v man/man8/arpd.8

sed -i '/netlink\//d' ip/ipl2tp.c

echo Patching...
patch -Np1 -i $DLD/iproute2-$VER-libdir-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

echo Making...
make CC="gcc ${BUILD64}" DESTDIR= LIBDIR=/usr/lib64 \
    DOCDIR=/usr/share/doc/iproute2 MANDIR=/usr/share/man \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make DESTDIR= LIBDIR=/usr/lib64 \
    DOCDIR=/usr/share/doc/iproute2 \
    MANDIR=/usr/share/man install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone
