#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

TARGET=linux-$LINUX_VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

install -dv /tools/include

echo \ \ Making mrproper...
make mrproper \
        1> $LOG/$CHAP.$TARGET.1_mrproper.log 2>&1 || exit 1

echo \ \ Making headers_check...
make headers_check \
        1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "\
make INSTALL_HDR_PATH=dest headers_install" \
        1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -rv dest/include/* /usr/include" \
        1> $LOG/$CHAP.$TARGET.4_copy.log 2>&1
paco -p+ $TARGET "\
find /usr/include -name .install -or -name ..install.cmd | xargs rm -fv" \
        1>> $LOG/$CHAP.$TARGET.4_copy.log 2>&1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
        >> $TME/clfstime.txt

echo \ \ Removing Directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

