#!/bin/sh

. ./_blfsset.sh

APPNAME=vlc
VER=2.1.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	lua alsa-lib ffmpeg libmad liba52 qt-4 libgcrypt
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_ffmpeg} -eq "1" ]; then
  export DISABLEAVCODEC=""
else
  export DISABLEAVCODEC="--disable-avcodec "
fi

if [ ${OPTION_libmad} -eq "1" ]; then
  export DISABLEMAD=""
else
  export DISABLEMAD="--disable-mad "
fi

if [ ${OPTION_liba52} -eq "1" ]; then
  export DISABLEA52=""
else
  export DISABLEA52="--disable-a52 "
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's:libsmbclient.h:samba-4.0/&:' modules/access/smb.c

echo Bootstrapping....
./bootstrap \
	1> $LOG/$TARGET.0_bootstrap.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
	    $DISABLEAVCODEC \
	    $DISABLEMAD \
	    $DISABLEA52 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
make docdir=/usr/share/doc/vlc-$VER install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

