#!/bin/sh

. ./_blfsset.sh

APPNAME=sudo
VER=1.8.9p4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	openafs Linux-PAM shadow sendmail
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

export WITHPAM=""

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --libexecdir=/usr/lib \
            --docdir=/usr/share/doc/sudo-$VER \
            --with-timedir=/var/lib/sudo \
            --with-all-insults \
	    --with-env-editor \
            --with-passprompt="[BLFS sudo] password for %p" \
	$([ ${OPTION_LinuxPAM} -ne 1 ] && echo --without-pam) \
	$([ ${OPTION_sendmail} -ne "1" ] && echo --without-sendmail) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

if [ ${OPTION_LinuxPAM} -eq 1 ]; then
cat > /etc/pam.d/sudo << "EOF"
# Begin /etc/pam.d/sudo

# include the default auth settings
auth      include     system-auth

# include the default account settings
account   include     system-account

# Set default environment variables for the service user
session   required    pam_env.so

# include system session defaults
session   include     system-session

# End /etc/pam.d/sudo
EOF
chmod 644 /etc/pam.d/sudo
paco -p+ $TARGET "touch /etc/pam.d/sudo"
fi

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

