#!/bin/sh

. ./_blfsset.sh

APPNAME=setuptools
VER=0.6c11
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

echo Check Required...
./_checkRequired.sh Python-2 || exit 1

echo -n Tarball $TARGETBALL" "
if [ -e $DLD/$TARGETBALL ]; then
  echo  found
else
  echo  not found && exit 1
fi

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Installing...
paco -p $TARGET "python setup.py install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

