#!/bin/sh

. ./_blfsset.sh

VER=4.11.1
TARGET=rpm-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	nspr nss popt db
. $WRK/_checkOptions.sh  \
	lua lzma neon openssl \
        pcre python sqlite dmalloc duma keyutils
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
CPPFLAGS="-I/usr/include/nspr -I/usr/include/nss " \
./configure --prefix=/usr --sysconfdir=/etc \
    --libdir=/usr/lib --localstatedir=/var/lib \
    --enable-build-pic --enable-build-pie \
    --disable-build-intlibdep --with-popt=/usr \
    --with-external-db \
    --without-lua \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

