#!/bin/sh

. ./_blfsset.sh

APPNAME=poppler
VER=0.24.5
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	fontconfig
. $WRK/_checkOptions.sh  \
	cairo libjpeg-turbo libpng curl gtk+-2 \
        lcms-1 lcms2 tiff libxml2 openjpeg qt-4
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --disable-static \
            --enable-xpdf-headers \
$([ ${OPTION_curl} -eq 1 ] && echo --enable-libcurl) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d      /usr/share/doc/poppler-$VER \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 README* /usr/share/doc/poppler-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo Extracting encoding data...
tar -xf $DLD/poppler-data-0.4.6.tar.gz \
	1> $LOG/$TARGET.4_data.log 2>&1 || exit 1

cd poppler-data-0.4.6
make prefix=/usr install \
	1> $LOG/$TARGET.5_install.log 2>&1 || exit 1

cd ..

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

