#!/bin/sh

. ./_blfsset.sh

APPNAME=MySQL-python
VER=1.2.4
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.zip
TARGETDIR=$TARGET

echo Check Required...
./_checkRequired.sh unzip mysql python setuptools || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extractZip.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Building...
python setup.py build \
	1> $LOG/$TARGET.2_build.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "python setup.py install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release 2>/dev/null || echo unknown`,\
$TARGET,$START,$END >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

