#!/bin/sh

. ./_blfsset.sh

APPNAME=tiff
VER=4.0.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh libjpeg-turbo jbigkit freeglut \
        Xorg-lib-libX11
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_jbigkit} -eq "1" ]; then
#  export ENABLEJBIG="--enable-jbig "
#else
#  export ENABLEJBIG=""
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching...
#patch -Np1 -i $DLD/tiff-3.8.2-fixes-2.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
	--disable-static \
	$([ ${OPTION_jbigkit} -eq "1" ] && echo --enable-jbig) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

