#!/bin/sh

. ./_blfsset.sh

APPNAME=libssh2
VER=1.4.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	libgcrypt
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_libgcrypt} -eq "1" ]; then
  export WITHGCRYPT="--with-libgcrypt "
else
  export WITHGCRYPT=""
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#patch -Np1 -i $WRK/patch/libssh2-$VER.patch 

Configuring
./configure --prefix=/usr \
        --disable-static  \
	$WITHGCRYPT       \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

