#!/bin/sh

. ./_kdeset.sh

QTDIR=/opt/qt

APPNAME=phonon
VER=4.7.1
TARGET=$APPNAME-$VER
TARGETBALL=$KDEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	automoc4 glib-2
. $WRK/_checkOptions.sh  \
	pulseaudio qzeitgeist
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Cmaking...
mkdir build
cd build
cmake -DCMAKE_INSTALL_PREFIX=$QTDIR \
      -DCMAKE_BUILD_TYPE=Release \
      -DPHONON_INSTALL_QT_EXTENSIONS_INTO_SYSTEM_QT=TRUE \
      -DDBUS_INTERFACES_INSTALL_DIR=/usr/share/dbus-1/interfaces \
      .. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

