#!/bin/sh

. ./_blfsset.sh

APPNAME=jbigkit
VER=2.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=jbigkit

echo $TARGET

echo Check Required...
./_checkRequired.sh  || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Making...
make CC="gcc -fPIC" \
	1> $LOG/$TARGET.1_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "\
cp pbmtools/{pbmtojbg,pbmtojbg85,jbgtopbm85,jbgtopbm} /usr/bin && \
cp libjbig/{tstcodec,tstcodec85} /usr/bin && \
cp libjbig/{libjbig.a,libjbig85.a} /usr/lib && \
cp libjbig/*.h /usr/include" \
	1> $LOG/$TARGET.2_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

