#!/bin/sh

. ./_blfsset.sh

APPNAME=gperf
VER=3.0.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr --docdir=/usr/share/doc/gperf-$VER \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -m644 -v doc/gperf.{dvi,ps,pdf} \
/usr/share/doc/gperf-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

pushd /usr/share/info
rm -v dir
for FILENAME in *; do
    install-info $FILENAME dir 2>/dev/null
done
popd

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

