#!/bin/sh

. ../_blfsset.sh
. ../Xorg/_xorgset.sh
. ./_gnomeset.sh

APPNAME=network-manager-applet
VER=0.9.8.0
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gtk+-3 gconf iso-codes \
        libgnome-keyring libnotify NetworkManager
. $WRK/_checkOptions.sh  \
	polkit-gnome gnome-bluetooth mobile-broadband-provider-info
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --libexecdir=/usr/lib/NetworkManager \
            --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

