#!/bin/sh

. ./_blfsset.sh

APPNAME=glib-networking
VER=2.38.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET
. $WRK/_checkRequired.sh \
	gnutls gsettings-desktop-schemas
. $WRK/_checkOptions.sh  \
	p11-kit libgcrypt libproxy
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --libexecdir=/usr/lib/glib-networking \
            --with-ca-certificates=/etc/ssl/ca-bundle.crt \
            --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

