#!/bin/sh

. ./_blfsset.sh

VER=15.0.1
TARGET=firefox-$VER
TARGETBALL=firefox-$VER.source.tar.bz2
TARGETDIR=mozilla-release

echo Check Required...
./_checkRequired.sh zip alsa-lib gtk+-2 unzip || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo Removing old directory...
rm -fr $TARGETDIR
rm -fr xulrunner-build

echo Extracting sources...
tar xf $DLD/$TARGETBALL

cd $TARGETDIR

cat > mozconfig << "EOF"
# If you have a multicore machine you can speed up the build by running
# several jobs at once, but if you have a single core, delete this line:
mk_add_options MOZ_MAKE_FLAGS="-j4"

# If you have not installed Yasm, uncomment this option:
# ac_add_options --disable-webm

# If you have installed DBus-Glib delete this option:
# ac_add_options --disable-dbus

# If you have installed wireless-tools delete this option:
ac_add_options --disable-necko-wifi

# If you have installed libnotify delete this option:
# ac_add_options --disable-libnotify

# If you have installed xulrunner uncomment these two lines:
# ac_add_options --with-system-libxul
# ac_add_options --with-libxul-sdk=\$(pkg-config --variable=sdkdir libxul)

# Uncomment these if you have installed them:
ac_add_options --enable-startup-notification
# ac_add_options --enable-system-hunspell
ac_add_options --enable-system-sqlite
ac_add_options --with-system-libevent
ac_add_options --with-system-libvpx
ac_add_options --with-system-nspr
ac_add_options --with-system-nss

mk_add_options MOZ_OBJDIR=@TOPSRCDIR@/firefox-build-dir
ac_add_options --enable-official-branding
ac_add_options --prefix=/usr

# The rest of these options have no effect if you're
# building against an already installed xulrunner:
ac_add_options --disable-crashreporter
ac_add_options --disable-debug
ac_add_options --disable-installer
ac_add_options --disable-static
ac_add_options --disable-tests
ac_add_options --disable-updater
ac_add_options --enable-shared
ac_add_options --enable-system-cairo
ac_add_options --enable-system-ffi
ac_add_options --with-pthreads
ac_add_options --with-system-jpeg
ac_add_options --with-system-png
ac_add_options --with-system-zlib
EOF

echo Making...
sed -i 's/\(MOZ_PKG_FATAL_WARNINGS =\).*/\1 0/' \
  browser/installer/Makefile.in
sed -i 's# ""##' browser/base/Makefile.in

make -f client.mk \
	1> $LOG/$TARGET.1_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make -C firefox-build-dir/browser/installer" \
	1> $LOG/$TARGET.2_install.log 2>&1 || exit 1

rm -rf /usr/lib/firefox-$VER
mkdir  /usr/lib/firefox-$VER

tar -xvf firefox-build-dir/dist/firefox-$VER.en-US.linux-$(uname -m).tar.bz2 \
    -C /usr/lib/firefox-$VER --strip-components=1  &&

ln -sfv ../lib/firefox-$VER/firefox /usr/bin
mkdir -pv /usr/lib/mozilla/plugins
ln -sfv ../mozilla/plugins /usr/lib/firefox-$VER
chown -R -v root:root /usr/lib/firefox-$VER

echo -n Pacoing:\   && paco $TARGET || echo none

mkdir -pv /usr/share/applications 

cat > /usr/share/applications/firefox.desktop << "EOF" &&
[Desktop Entry]
Encoding=UTF-8
Type=Application
Name=Firefox
Comment=Browse The Web
Icon=firefox
Exec=firefox
Categories=Network;GTK;Application;Browser;WebBrowser;
StartupNotify=true
Terminal=false
EOF

ln -sfv /usr/lib/firefox-$VER/icons/mozicon128.png /usr/share/pixmaps/firefox.png

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR 

