#!/bin/sh

. ./_blfsset.sh

APPNAME=autogen
VER=5.12
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

echo Check Required...
./_checkRequired.sh guile || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/autogen-$VER-build_shared-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo \ \ Configuring...
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

