#!/bin/sh

. ../_blfsset.sh

VER=25.0
TARGET=xulrunner-$VER
TARGETBALL=$DLD/firefox-$VER.source.tar.bz2
TARGETDIR=mozilla-release

echo $TARGET

. $WRK/_checkRequired.sh \
	alsa-lib gtk+-2 zip unzip
. $WRK/_checkOptions.sh  \
	dbus-glib wireless_tools libnotify \
        gstreamer-0 hunspell startup-notification \
        cairo yasm sqlite libevent libvpx \
        nspr nss
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

. $WRK/Xorg/mk_mozconfig.sh

echo Making...
make -f client.mk \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make -f xulrunner-build-dir install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

mkdir -pv /usr/lib/mozilla/plugins
rm -rf /usr/lib/xulrunner-$VER/plugins
ln -sv ../mozilla/plugins /usr/lib/xulrunner-$VER

chmod -v 755 /usr/lib/xulrunner-devel-$VER/sdk/bin/xpcshell

for library in libmozalloc.so libmozjs.so libxul.so; do
    ln -sfv ../../../xulrunner-$VER/$library \
            /usr/lib/xulrunner-devel-$VER/sdk/lib/$library
    ln -sfv xulrunner-$VER/$library /usr/lib/$library
done

ln -sfv ../xulrunner-devel-$VER/sdk/bin/run-mozilla.sh \
        /usr/lib/xulrunner-$VER
ln -sfv ../xulrunner-devel-$VER/sdk/bin/xpcshell \
        /usr/lib/xulrunner-$VER

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

