#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

section=driver
version=$XORGVERSION

TARGET=${section}-${version}
TARGETDIR=${section}


mkdir -pv $XORGDLD/$TARGETDIR
mkdir -pv $XORGSRC/$TARGETDIR

cd $XORGDLD/$TARGETDIR

echo Wgetting...
grep -v '^#' ../${section}-${version}.wget | wget -N -i- -c \
    -B http://xorg.freedesktop.org/releases/individual/${section}/ \
	1> $LOG/Xorg-$section.log 2>&1 
md5sum -c ../${section}-${version}.md5 \
	1>> $LOG/Xorg-$section.log 2>&1

cd $XORGSRC/$TARGETDIR

# build packages
for package in $(grep -v '^#' $XORGDLD/${section}-${version}.wget)
do
  packagedir=$(echo $package | sed 's/.tar.bz2//')
echo $packagedir
echo \ \ Removing old directory...
  rm -fr $packagedir
echo \ \ Extracting...
  tar -xf $XORGDLD/$TARGETDIR/$package || (echo Tarball not found && exit 1)
  cd $packagedir

case $(basename "$PWD") in
xf86-input-evdev-[0-9]* | xf86-video-ati-[0-9]* | \
xf86-video-fbdev-[0-9]* | xf86-video-glint-[0-9]* | \
xf86-video-newport-[0-9]* )
    sed -i -e "s/\xc3\xb8/\\\\[\/o]/" \
           -e "s/\xc3\xa4/\\\\[:a]/" \
           -e "s/\xc3\x9c/\\\\[:U]/" man/*.man
    ;;
esac &&
case $(basename "$PWD") in
xf86-video-s3-[0-9]* | xf86-video-xgi-[0-9]* )
    for file in `grep -Rl "xf86Version.h" *`
    do
        sed 's@xf86Version.h@xorgVersion.h@g' -i "$file"
    done
    ;;
esac
case $(basename "$PWD") in
xf86-video-vmware-[0-9]* )

#echo \ \ Patching...
#    patch -Np1 -i $WRK/patch/xf86-video-vmware-10.16.8.patch \
#	1> $LOG/$packagedir.0_patch.log 2>&1 || exit 1
    ;;
xf86-video-s3-[0-9]* | xf86-video-xgi-[0-9]* )
    for file in `grep -Rl "xf86Version.h" *`
    do
        sed 's@xf86Version.h@xorgVersion.h@g' -i "$file"
    done
    ;;
esac

#case $(basename "$PWD") in
#xf86-video-xgixp-[0-9]* )
#
#echo \ \ Patching...
#    patch -Np1 -i $DLD/xf86-video-xgixp-1.7.99.4.patch \
#	1> $LOG/$packagedir.0_patch.log 2>&1 || exit 1
#    ;;
#esac

echo \ \ Configuring...
  ./configure $XORG_CONFIG \
    --with-xorg-module-dir=$XORG_PREFIX/lib/X11/modules \
	1> $LOG/$packagedir.1_conf.log 2>&1 || exit 1
echo \ \ Making...
  make \
	1> $LOG/$packagedir.2_make.log 2>&1 || exit 1
echo \ \ Installing...
  paco -p Xorg-${section}-${packagedir} 'make install' \
	1> $LOG/$packagedir.3_install.log 2>&1 || exit 1
  cd ..
echo -n \ \ Pacoing:\   && paco Xorg-${section}-${packagedir} || echo none
echo \ \ Removing directory...
  rm -fr $packagedir
done

echo y | paco -rr Xorg-${section}-xf86-video-newport
echo y | paco -rr Xorg-${section}-xf86-video-xgi
echo y | paco -rr Xorg-${section}-xf86-video-xgixp
echo y | paco -rr Xorg-${section}-xf86-video-fbdev

