#!/bin/sh

. ./_blfsset.sh

APPNAME=takao-fonts-ttf
VER=003.02.01
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh fontconfig
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

paco -p $TARGET "install -d -m755 /usr/share/fonts/takao-gothic"
paco -p+ $TARGET "install -d -m755 /usr/share/fonts/takao-mincho"

Installing
paco -p+ $TARGET "\
install -v -m644 Takao*Gothic.ttf /usr/share/fonts/takao-gothic" \
	1> $LOG/$TARGET.1_install.log 2>&1 || exit 1
 
paco -p+ $TARGET "\
install -v -m644 Takao*Mincho.ttf /usr/share/fonts/takao-mincho" \
	1>> $LOG/$TARGET.1_install.log 2>&1 || exit 1

fc-cache -v /usr/share/fonts/takao-gothic \
	1>> $LOG/$TARGET.1_install.log 2>&1 || exit 1
fc-cache -v /usr/share/fonts/takao-mincho \
	1>> $LOG/$TARGET.1_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

