#!/bin/sh

CHAP=8
APPNAME=readline
VER=8.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i '/MV.*old/d' Makefile.in
sed -i '/{OLDSUFF}/c:' support/shlib-install

echo \ \ Configuring...
./configure --prefix=/usr    \
            --disable-static \
	    --with-curses    \
            --docdir=/usr/share/doc/readline-$VER \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make SHLIB_LIBS="-lncursesw" \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make SHLIB_LIBS=\"-lncursesw\" install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -v /usr/lib/lib{readline,history}.so.* /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
chmod -v u+w /lib/lib{readline,history}.so.* \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libreadline.so) /usr/lib/libreadline.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libhistory.so ) /usr/lib/libhistory.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

#porg -lp+ $TARGET "\
#install -v -m644 doc/*.{ps,pdf,html,dvi} /usr/share/doc/readline-$VER" \
#	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || echo Error occured while copying

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
