#!/bin/sh

CHAP=8
APPNAME=ninja
VER=1.10.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
python3 configure.py --bootstrap \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "\
install -vm755 ninja /usr/bin/" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#install -vDm644 misc/ninja.vim \
#                /usr/share/vim/vim80/syntax/ninja.vim" \
#	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -vDm644 misc/bash-completion \
                /usr/share/bash-completion/completions/ninja" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -vDm644 misc/zsh-completion \
                /usr/share/zsh/site-functions/_ninja" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
