#!/bin/sh

CHAP=8
APPNAME=bzip2
VER=1.0.8
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/bzip2-$VER-install_docs-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's@\(ln -s -f \)$(PREFIX)/bin/@\1@' Makefile
sed -i "s@(PREFIX)/man@(PREFIX)/share/man@g" Makefile

echo \ \ Making...
make -f Makefile-libbz2_so \
	1> $LOG/$CHAP.$TARGET.1_make.log 2>&1 || exit 1
echo \ \ Cleaning...
make clean \
	1> $LOG/$CHAP.$TARGET.2_clean.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.3_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make PREFIX=/usr install" \
	1> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

porg -lp+ $TARGET "cp -v bzip2-shared /bin/bzip2" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1
porg -lp+ $TARGET "cp -av libbz2.so* /lib" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1
porg -lp+ $TARGET "ln -sv ../../lib/libbz2.so.1.0 /usr/lib/libbz2.so" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
rm -v /usr/bin/{bunzip2,bzcat,bzip2}" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1
porg -lp+ $TARGET "ln -sv bzip2 /bin/bunzip2" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1
porg -lp+ $TARGET "ln -sv bzip2 /bin/bzcat" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
