#!/bin/sh

CHAP=8
APPNAME=attr
VER=2.4.48
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr \
            --disable-static \
            --sysconfdir=/etc \
            --docdir=/usr/share/doc/attr-$VER \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "\
make install " \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
#chmod 755 /usr/lib/libattr.so

porg -lp+ $TARGET "\
mv -v /usr/lib/libattr.so.* /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libattr.so) /usr/lib/libattr.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
