#!/bin/sh

CHAP=7
TARGET=kernfs

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

mkdir -pv $LFS/{dev,proc,sys,run}

mknod -m 600 $LFS/dev/console c 5 1
mknod -m 666 $LFS/dev/null c 1 3

mount -v --bind /dev $LFS/dev

mount -v --bind /dev/pts $LFS/dev/pts
mount -vt proc proc $LFS/proc
mount -vt sysfs sysfs $LFS/sys
mount -vt tmpfs tmpfs $LFS/run

if [ -h $LFS/dev/shm ]; then
  mkdir -pv $LFS/$(readlink $LFS/dev/shm)
fi

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/_lfstime.txt

###
mkdir -pv /mnt/lfs/etc
cp -p /etc/lfs-release /mnt/lfs/etc
sed -i 's/$/(chroot)/' /mnt/lfs/etc/lfs-release

mkdir -pv /mnt/lfs/root/.ssh
cp -p /root/.ssh/id_rsa /mnt/lfs/root/.ssh

echo Done.
