#!/bin/sh

CHAP=6
APPNAME=coreutils
VER=8.32
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr                     \
            --host=$LFS_TGT                   \
            --build=$(build-aux/config.guess) \
            --enable-install-program=hostname \
            --enable-no-install-program=kill,uptime \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make DESTDIR=$LFS install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

mv -v $LFS/usr/bin/{cat,chgrp,chmod,chown,cp,date,dd,df,echo} $LFS/bin \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
mv -v $LFS/usr/bin/{false,ln,ls,mkdir,mknod,mv,pwd,rm}        $LFS/bin \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
mv -v $LFS/usr/bin/{rmdir,stty,sync,true,uname}               $LFS/bin \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
mv -v $LFS/usr/bin/{head,nice,sleep,touch}                    $LFS/bin \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
mv -v $LFS/usr/bin/chroot                                     $LFS/usr/sbin \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
mkdir -pv $LFS/usr/share/man/man8 \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
mv -v $LFS/usr/share/man/man1/chroot.1                        $LFS/usr/share/man/man8/chroot.8 \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
sed -i 's/"1"/"8"/'                                           $LFS/usr/share/man/man8/chroot.8 \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
