#!/bin/sh

CHAP=6
TARGET=adjusting

echo $TARGET

. ./_lfsset.sh

if test ! -f /tools/bin/ld-old; then
  mv -v /tools/bin/{ld,ld-old}
fi
if test ! -f /tools/$(uname -m)-pc-linux-gnu/bin/ld-old; then
  mv -v /tools/$(uname -m)-pc-linux-gnu/bin/{ld,ld-old}
fi
if test ! -f /tools/bin/ld; then
  mv -v /tools/bin/{ld-new,ld}
fi
if test ! -f /tools/$(uname -m)-pc-linux-gnu/bin/ld; then
  ln -sv /tools/bin/ld /tools/$(uname -m)-pc-linux-gnu/bin/ld
fi

gcc -dumpspecs | sed -e 's@/tools@@g'                   \
    -e '/\*startfile_prefix_spec:/{n;s@.*@/usr/lib/ @}' \
    -e '/\*cpp:/{n;s@$@ -idirafter /usr/include@}' >      \
    `dirname $(gcc --print-libgcc-file-name)`/specs

echo 'int main(){}' > dummy.c
cc dummy.c -v -Wl,--verbose &> dummy.log
readelf -l a.out | grep ': /lib' \
  >$LOG/6.adjunsting.log 2>&1

grep -o '/usr/lib.*/crt[1in].*succeeded' dummy.log \
  >>$LOG/6.adjunsting.log 2>&1

grep -B4 '^ /usr/include' dummy.log \
  >>$LOG/6.adjunsting.log 2>&1

grep 'SEARCH.*/usr/lib' dummy.log |sed 's|; |\n|g' \
  >>$LOG/6.adjunsting.log 2>&1

grep "/lib.*/libc.so.6 " dummy.log \
  >>$LOG/6.adjunsting.log 2>&1

grep found dummy.log \
  >>$LOG/6.adjunsting.log 2>&1

#rm -v dummy.c a.out dummy.log
