#!/bin/sh

CHAP=5
APPNAME=glibc
VER=2.31
KERNELVER=3.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

case $(uname -m) in
    i?86)   ln -sfv ld-linux.so.2 $LFS/lib/ld-lsb.so.3
    ;;
    x86_64) ln -sfv ../lib/ld-linux-x86-64.so.2 $LFS/lib64
            ln -sfv ../lib/ld-linux-x86-64.so.2 $LFS/lib64/ld-lsb-x86-64.so.3
    ;;
esac

echo \ \ Patching...
patch -Np1 -i $DLD/glibc-$VER-fhs-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

mkdir build
cd    build

echo \ \ Configuring...
../configure                             \
      --prefix=/usr                      \
      --host=$LFS_TGT                    \
      --build=$(../scripts/config.guess) \
      --enable-kernel=3.2                \
      --with-headers=$LFS/usr/include    \
      libc_cv_slibdir=/lib               \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make DESTDIR=$LFS install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

echo 'int main(){}' > dummy.c
$LFS_TGT-gcc dummy.c || (echo Compile error && exit 1)
readelf -l a.out | grep ': /tools'
rm dummy.c a.out

$LFS/tools/libexec/gcc/$LFS_TGT/10.1.0/install-tools/mkheaders

TimeEnd chap5

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
