BOOTSCRIPTVER=20140710
SVNVER=3.0.0
LINUX_VER=3.14.21

CLFS=/mnt/clfs
SRC=$CLFS/src/sources/CLFS
DLD=$CLFS/src/download
WRK=$CLFS/work/LFScripts/CLFS
LOG=$WRK/log
TME=$WRK/time

mkdir -pv $LOG $TME

THISFILE=`basename $0 | sed 's/\.sh$//'`

function TimeStart() {
  START=`date +'%Y/%m/%d %H:%M:%S.%N'`
  return 0
}

function TimeEnd() {
  END=`date +'%Y/%m/%d %H:%M:%S.%N'`
  echo $THISFILE,$TARGET,$START,$END \
        >> $TME/clfstime.txt
}

function RemoveSrcDir() {
  echo Removing source directory...
  rm -fr $TARGETDIR
}

function Extract() {
  local FILE=$TARGETBALL

  if test "$1" != ""; then
    FILE=$1
  fi

  echo Extracting sources...
  if test ! -f $FILE; then
    echo \ \ Tarball not found: $FILE && exit 1
  else
    tar xf $FILE
  fi
}

function PorgingDone() {
  local pkg=$TARGET
  if test "$1" != ""; then
    pkg=$1
  fi
  echo --------------------
  echo -n Porging:\   && porg $pkg || echo none
  echo Done.
}
