#/bin/sh

. ./_clfsset.sh

APPNAME=gcc
VER=4.8.3
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

echo Patching...
patch -Np1 -i $DLD/gcc-$VER-branch_update-1.patch \
        1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/gcc-$VER-specs-1.patch \
        1>> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo -en '\n#undef STANDARD_STARTFILE_PREFIX_1\n#define STANDARD_STARTFILE_PREFIX_1 "/tools/lib/"\n' >> gcc/config/linux.h
echo -en '\n#undef STANDARD_STARTFILE_PREFIX_2\n#define STANDARD_STARTFILE_PREFIX_2 ""\n' >> gcc/config/linux.h

mkdir ../gcc-build
cd ../gcc-build

echo Configuring...
AR=ar LDFLAGS="-Wl,-rpath,/cross-tools/lib" \
    ../gcc-$VER/configure --prefix=/cross-tools \
    --build=${CLFS_HOST} --target=${CLFS_TARGET} --host=${CLFS_HOST} \
    --with-sysroot=${CLFS} --with-local-prefix=/tools \
    --with-native-system-header-dir=/tools/include \
    --disable-nls --disable-static --enable-languages=c,c++ \
    --enable-__cxa_atexit --enable-threads=posix --with-mpc=/cross-tools \
    --with-mpfr=/cross-tools --with-gmp=/cross-tools --with-cloog=/cross-tools \
    --with-isl=/cross-tools --with-system-zlib --enable-checking=release \
    --enable-libstdcxx-time \
        1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make AS_FOR_TARGET="${CLFS_TARGET}-as" \
    LD_FOR_TARGET="${CLFS_TARGET}-ld" \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
rm -fr gcc-build

echo Done.

