#/bin/sh

. ./_cblfsset.sh

APPNAME=Python
APPVER=2
VER=2.7.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

checkRequired ""
checkOptions  \
	expat pkg-config pkg-config-lite libffi \
	bluez sphinx openssl tk db sqlite \
        valgrind
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT32
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

sed -i "s@/usr/X11R6@${XORG_PREFIX}@g" setup.py
sed -i 's@/lib64@/lib@g' Modules/_ctypes/libffi/m4/libtool.m4 \
    Modules/_ctypes/libffi/configure setup.py
sed -i "s/'lib64'/'lib'/g" setup.py

echo Configuring...
CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" \
./configure --prefix=/usr \
    --enable-shared \
	1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/python{,-32}" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/python2{,-32}" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/python2.7{,-32}" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/include/python2.7/pyconfig{,-32}.h" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv python2.7-32 /usr/bin/python2-32" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv python2-32 /usr/bin/python-32" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..

BIT64
RemoveSrcDir
Extract

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/Python-$VER-multilib-1.patch \
        1> $LOG/$TARGET.$BIT.0_patch.log 2>&1 || exit 1

sed -i -e "s|@@MULTILIB_DIR@@|/lib64|g" Lib/distutils/command/install.py \
       Lib/distutils/sysconfig.py \
       Lib/pydoc.py \
       Lib/site.py \
       Lib/sysconfig.py \
       Lib/test/test_dl.py \
       Lib/test/test_site.py \
       Lib/trace.py \
       Makefile.pre.in \
       Modules/getpath.c \
       setup.py
sed -i "s@/usr/X11R6@${XORG_PREFIX}@g" setup.py

echo Configuring...
CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" \
./configure --prefix=/usr \
    --libdir=/usr/lib64 --enable-shared \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/bin/python{,-64}" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/python2{,-64}" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/python2.7{,-64}" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv python2.7-64 /usr/bin/python2-64" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv python2-64 /usr/bin/python-64" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv multiarch_wrapper /usr/bin/python" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv multiarch_wrapper /usr/bin/python2" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv multiarch_wrapper /usr/bin/python2.7" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/include/python2.7/pyconfig{,-64}.h" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

cat > /usr/include/python2.7/pyconfig.h << "EOF"
/* pyconfig.h - Stub Header  */
#ifndef __STUB__PYCONFIG_H__
#define __STUB__PYCONFIG_H__

#if defined(__x86_64__) || \
    defined(__sparc64__) || \
    defined(__arch64__) || \
    defined(__powerpc64__) || \
    defined (__s390x__)
# include "pyconfig-64.h"
#else
# include "pyconfig-32.h"
#endif

#endif /* __STUB__PYCONFIG_H__ */
EOF
paco -p+ $TARGET "touch /usr/include/python2.7/pyconfig.h" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

