#!/bin/sh

. ./_blfsset.sh

APPNAME=tslib
VER=1.0.106
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/kergoth-tslib-1.0-106-gf6c499a.tar.gz
TARGETDIR=kergoth-tslib-f6c499a

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i "s/AM_CONFIG_HEADER/AC_CONFIG_HEADERS/g" configure.ac

echo Autogen...
./autogen.sh \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

