#!/bin/sh

. ./_blfsset.sh

APPNAME=samba
VER=4.12.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	jansson libtirpc lmdb rpcsvc-proto gnutls \
	parse-yapp
. $WRK/_checkOptions.sh  \
	libarchive gpgme \
	popt Linux-PAM cups openldap gamin xfsprogs \
	krb5 libxslt tdb ctdb libunwind \
	avahi openafs valgrind 
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#sed -e "s:(Function \*)callback:(rl_command_func_t \*)callback:g" \
#    -i libcli/smbreadline/smbreadline.c

# --enable-nss-wrapper                \

echo "^samba4.rpc.echo.*on.*ncacn_np.*with.*object.*nt4_dc" >> selftest/knownfail

Configuring
CFLAGS="-I/usr/include/tirpc"           \
LDFLAGS="-ltirpc"                       \
./configure                             \
    --prefix=/usr                       \
    --sysconfdir=/etc                   \
    --localstatedir=/var                \
    --with-piddir=/run/samba            \
    --with-pammodulesdir=/lib/security  \
    --enable-fhs                        \
$([ ${OPTION_LinuxPAM} -ne 1 ] && echo --without-pam) \
$([ ${OPTION_openldap} -ne 1 ] && echo --without-ads --without-ldap) \
$([ ${OPTION_gpgme} -ne 1 ] && echo --without-gpgme --without-ad-dc) \
$([ ${OPTION_libarchive} -ne 1 ] && echo --without-libarchive) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET -E$TARGETDIR/* "\
make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -v /usr/lib/libnss_win{s,bind}.so*   /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -v -sf ../../lib/libnss_winbind.so.2 /usr/lib/libnss_winbind.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -v -sf ../../lib/libnss_wins.so.2    /usr/lib/libnss_wins.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644    examples/smb.conf.default /etc/samba" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
sed -e "s/MYGROUP/WORKGROUP/" \
    -e "s/writable = yes/writable = yes\n   create mask = 0644\n   directory mask = 0755/" /etc/samba/smb.conf.default > /etc/samba/smb.conf
sed -i -e '/log file =/s/\/usr\/local\/samba\/var\/log/\/var\/log\/samba/' \
	/etc/samba/smb.conf
porg -lp+ $TARGET "touch /etc/samba/smb.conf"

if test ${OPTION_openldap} -eq 1; then
mkdir -pv /etc/openldap/schema 

porg -lp+ $TARGET "\
install -v -m644    examples/LDAP/README              \
                    /etc/openldap/schema/README.LDAP" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
                    
porg -lp+ $TARGET "\
install -v -m644    examples/LDAP/samba*              \
                    /etc/openldap/schema" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
                    
porg -lp+ $TARGET "\
install -v -m755    examples/LDAP/{get*,ol*} \
                    /etc/openldap/schema" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
fi

#install -v -m755 -d /usr/share/doc/samba-$VER

#porg -lp+ $TARGET "\
#install -v -m644    lib/ntdb/doc/design.pdf \
#                    /usr/share/doc/samba-$VER" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

