#!/bin/sh

. ./_blfsset.sh

APPNAME=Python
APPVER=2
VER=2.7.18
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	bluez tk sqlite \
        valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#Patching
#patch -Np1 -i $DLD/python2-myworkaround.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#sed -i '/#SSL/,+3 s/^#//' Modules/Setup.dist

#$([ ${OPTION_pth} -eq 1 ] && echo --with-pth) \
Configuring
./configure \
--prefix=/usr \
--enable-shared \
--with-system-expat \
--with-system-ffi \
--with-ensurepip=yes \
$([ ${OPTION_valgrind} -eq 1 ] && echo --with-valgrind) \
	--enable-unicode=ucs4 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make -j1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET -E/tmp:`pwd` "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod -v 755 /usr/lib/libpython2.7.so.1.0 \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
